<?php
function text_date($date){
    
    $dan = date('w',strtotime($date));
    $mesec = date('n',strtotime($date));
    
    $slo = array('Nedelja','Ponedeljek','Torek','Sreda','Četrtek','Petek','Sobota');
    $key = array('0','1','2','3','4','5','6');
    $slo2 = array('januar','februar','marec','april','maj','junij','julij','avgust','september','november','december');
    $key2 = array('1','2','3','4','5','6','7','8','9','10','11','12');
    
    $dan = str_replace($key, $slo, $dan);
    $mesec = str_replace($key2, $slo2, $mesec);
    return $dan . ',' . date('d', strtotime($date)) . '. ' . $mesec;
}

function url_frendly2($str) {
    // make replace of special characters
    $find = array("č", "š", "ž", "đ", "ć");
    $replace = array("c", "s", "z", "d", "c");
    $url = strtolower(str_replace($find, $replace, $str));

    // remove all other special characters
    $url = preg_replace("/[^A-Za-z0-9. ]/", "", trim($url));
    $url = str_replace(' ', '-', $url);
    return $url;
}

function resize($filename, $youtube = FALSE, $facebook = FALSE) {
    if ($filename != "") {
        $info = pathinfo($filename);
        if (!isset($info['extension'])) {
            $filename = $filename . ".jpg";
        }

        $parts = explode("/", $filename);
        if ($youtube == TRUE) {
            $filename2 = end($parts);
            $id = prev($parts);
            $filename2 = $id . $filename2;
        } elseif ($facebook == TRUE) {
            $parts2 = explode("?oh=", end($parts));
            $filename2 = $parts2[0];
        } elseif ($youtube == FALSE && $facebook == FALSE) {
            $filename2 = end($parts);
            $filename2 = rtrim($filename2, "");
        }

        $folder = 'hub' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        $directory = DIR_IMAGE2 . $folder;
        if (!is_dir($directory)) {
            $oldmask = umask(0);
            mkdir($directory, 0777, true);
            umask($oldmask);
        }

        $new_image = $folder . url_frendly2($filename2);

        $filename = preg_replace('/([^:])(\/{2,})/', '$1/', $filename);
        $filename = str_replace(' ', '%20', $filename);
        $filename = str_replace('_show', '', $filename);

        if (!file_exists(DIR_IMAGE2 . $new_image)) {

            $image = new Image_moo;
            $image->load($filename)
                    ->resize(300, 600)
                    ->save(DIR_IMAGE2 . $new_image);
        }

        return 'http://static.sconnected.net/img/' . $new_image;
    }
}

function resize_hires($filename, $youtube = FALSE, $facebook = FALSE) {
    if ($filename != "") {
        $info = pathinfo($filename);
        if (!isset($info['extension'])) {
            $filename = $filename . ".jpg";
        }

        $parts = explode("/", $filename);
        if ($youtube == TRUE) {
            $filename2 = end($parts);
            $id = prev($parts);
            $filename2 = $id . $filename2;
        } elseif ($facebook == TRUE) {
            $parts2 = explode("?oh=", end($parts));
            $filename2 = $parts2[0];
        } elseif ($youtube == FALSE && $facebook == FALSE) {
            $filename2 = end($parts);
            $filename2 = rtrim($filename2, "");
        }

        $folder = 'hub' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        $directory = DIR_IMAGE2 . 'hires/' . $folder;
        if (!is_dir($directory)) {
            $oldmask = umask(0);
            mkdir($directory, 0777, true);
            umask($oldmask);
        }

        $new_image = 'hires/' . $folder . url_frendly2($filename2);

        $filename = preg_replace('/([^:])(\/{2,})/', '$1/', $filename);
        $filename = str_replace(' ', '%20', $filename);
        $filename = str_replace('_show', '', $filename);

        if (!file_exists(DIR_IMAGE2 . $new_image)) {

            $image = new Image_moo;
            $image->load($filename)
                    ->resize(600, 1200)
                    ->save(DIR_IMAGE2 . $new_image);
        }

        return 'http://static.sconnected.net/img/' . $new_image;
    }
}

function resize2($filename, $imagename) {
    if ($filename != "") {
        $filename2 = $imagename . ".jpg";

        $folder = 'hub' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        $directory = DIR_IMAGE2 . $folder;
        if (!is_dir($directory)) {
            $oldmask = umask(0);
            mkdir($directory, 0777, true);
            umask($oldmask);
        }

        $new_image = $folder . url_frendly2($filename2);

        if (!file_exists(DIR_IMAGE2 . $new_image)) {

            $image = new Image_moo;
            $image->load($filename)
                    ->resize(300, 600)
                    ->save(DIR_IMAGE2 . $new_image);
        }

        return 'http://static.sconnected.net/img/' . $new_image;
    }
}

function resize2_hires($filename, $imagename) {
    if ($filename != "") {
        $filename2 = $imagename . ".jpg";

        $folder = 'hub' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        $directory = DIR_IMAGE2 . 'hires/' . $folder;
        if (!is_dir($directory)) {
            $oldmask = umask(0);
            mkdir($directory, 0777, true);
            umask($oldmask);
        }

        $new_image = 'hires/' . $folder . url_frendly2($filename2);

        if (!file_exists(DIR_IMAGE2 . $new_image)) {

            $image = new Image_moo;
            $image->load($filename)
                    ->resize(600, 1200)
                    ->save(DIR_IMAGE2 . $new_image);
        }

        return 'http://static.sconnected.net/img/' . $new_image;
    }
}

function resize3($filename, $youtube = FALSE, $facebook = FALSE) {
    if ($filename != "") {
        $parts = explode("/", $filename);
        if ($youtube == TRUE) {
            $filename2 = end($parts);
            $id = prev($parts);
            $filename2 = $id . $filename2;
        } elseif ($facebook == TRUE) {
            $parts2 = explode("?oh=", end($parts));
            $filename2 = $parts2[0];
        } elseif ($youtube == FALSE && $facebook == FALSE) {
            $filename2 = end($parts);
        }

        $folder = 'hub' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        $directory = DIR_IMAGE2 . $folder;
        if (!is_dir($directory)) {
            $oldmask = umask(0);
            mkdir($directory, 0777, true);
            umask($oldmask);
        }

        $new_image = url_frendly2($filename2);
        $filename = str_replace(' ', '%20', preg_replace('/([^:])(\/{2,})/', '$1/', $filename));

        if (!file_exists("http://static.sconnected.net/img/temp/" . $new_image)) {
            $arrContextOptions = array(
                "ssl" => array(
                    "verify_peer" => false,
                    "verify_peer_name" => false,
                ),
            );

            //Get the file
            $content = file_get_contents($filename, false, stream_context_create($arrContextOptions));

            //Store in the filesystem.
            $fp = fopen(DIR_IMAGE2 . "temp/" . $new_image, "w+");
            fwrite($fp, $content);
            fclose($fp);
        }
        if (!file_exists(DIR_IMAGE2 . $folder . $new_image)) {
            $image = new Image_moo;
            $image->load(DIR_IMAGE2 . "temp/" . $new_image)
                    ->resize(300, 600)
                    ->save(DIR_IMAGE2 . $folder . $new_image);
        }

        return 'http://static.sconnected.net/img/' . $folder . $new_image;
    }
}

function resize3_hires($filename, $youtube = FALSE, $facebook = FALSE) {
    if ($filename != "") {
        $parts = explode("/", $filename);
        if ($youtube == TRUE) {
            $filename2 = end($parts);
            $id = prev($parts);
            $filename2 = $id . $filename2;
        } elseif ($facebook == TRUE) {
            $parts2 = explode("?oh=", end($parts));
            $filename2 = $parts2[0];
        } elseif ($youtube == FALSE && $facebook == FALSE) {
            $filename2 = end($parts);
        }

        $folder = 'hub' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        $directory = DIR_IMAGE2 . 'hires/' . $folder;
        if (!is_dir($directory)) {
            $oldmask = umask(0);
            mkdir($directory, 0777, true);
            umask($oldmask);
        }

        $new_image = url_frendly2($filename2);
        $filename = str_replace(' ', '%20', preg_replace('/([^:])(\/{2,})/', '$1/', $filename));

        if (!file_exists("http://static.sconnected.net/img/temp/" . $new_image)) {
            $arrContextOptions = array(
                "ssl" => array(
                    "verify_peer" => false,
                    "verify_peer_name" => false,
                ),
            );

            //Get the file
            $content = file_get_contents($filename, false, stream_context_create($arrContextOptions));

            //Store in the filesystem.
            $fp = fopen(DIR_IMAGE2 . "temp/" . $new_image, "w+");
            fwrite($fp, $content);
            fclose($fp);
        }
        if (!file_exists(DIR_IMAGE2 . 'hires/' . $folder . $new_image)) {
            $image = new Image_moo;
            $image->load(DIR_IMAGE2 . "temp/" . $new_image)
                    ->resize(600, 1200)
                    ->save(DIR_IMAGE2 . 'hires/' . $folder . $new_image);
        }

        return 'http://static.sconnected.net/img/hires/' . $folder . $new_image;
    }
}

function resize4($filename, $width, $height) {
    $parts = explode("/", $filename);
    $filename2 = end($parts);
    $new_image = 'cache/orig_' . url_frendly2($filename2);
    if (!file_exists(DIR_IMAGE2 . $new_image)) {

        $image = new Image_moo;
        $image->load($filename)
                ->resize_crop($width, $height)
                ->save(DIR_IMAGE2 . $new_image);
    }

    return 'http://static.sconnected.net/img/' . $new_image;
}

function resize5($filename, $width, $height) {
    $parts = explode("/", $filename);
    $filename2 = end($parts);
    $new_image = 'cache/' . $width . 'x' . $height . '_' . url_frendly2($filename2);

    if (!file_exists(DIR_IMAGE . $new_image)) {

        $image = new Image_moo;
        $image->load($filename)
                ->resize_crop($width, $height)
                ->save(DIR_IMAGE . $new_image);
    }

    return site_url() . 'img/' . $new_image;
}

function resize6($filename, $width, $height, $club) {
    $parts = explode("/", $filename);
    $filename2 = end($parts);
    $new_image = 'cache/' . $width . 'x' . $height . '_' . url_frendly2($filename2);

    if (!file_exists(DIR_ROOT . 'assets/' . $club . '/img/' . $new_image)) {

        $image = new Image_moo;
        $image->load($filename)
                ->resize_crop($width, $height)
                ->save(DIR_ROOT . 'assets/' . $club . '/img/' . $new_image);
    }

    return site_url() . 'assets/' . $club . '/img/' . $new_image;
}

function get_mesec($string) {
    switch ($string) {
        case "Siječanj":
        case "sij":
        case "januar":
        case "Jan":
        case "jan":
            $mesec = "01";
            break;
        case "februar":
        case "Feb":
        case "feb":
        case "Veljača":
        case "vel":
            $mesec = "02";
            break;
        case "marec":
        case "mart":
        case "Mar":
        case "mar":
        case "Ožujak":
        case "ožu":
            $mesec = "03";
            break;
        case "april":
        case "Apr":
        case "apr":
        case "Travanj":
        case "tra":
            $mesec = "04";
            break;
        case "maj":
        case "May":
        case "Svibanj":
        case "svi":
            $mesec = "05";
            break;
        case "junij":
        case "jun":
        case "Jun":
        case "Lipanj":
        case "lip":
            $mesec = "06";
            break;
        case "julij":
        case "jul":
        case "Jul":
        case "Srpanj":
        case "srp":
            $mesec = "07";
            break;
        case "avgust":
        case "Aug":
        case "aug":
        case "Kolovoz":
        case "kol":
            $mesec = "08";
            break;
        case "september":
        case "septembar":
        case "Sep":
        case "sep":
        case "Rujan":
        case "ruj":
            $mesec = "09";
            break;
        case "oktober":
        case "oktobar":
        case "Oct":
        case "okt":
        case "Listopad":
        case "lis":
            $mesec = "10";
            break;
        case "november":
        case "novembar":
        case "Nov":
        case "nov":
        case "Studeni":
        case "stu":
            $mesec = "11";
            break;
        case "december":
        case "decembar":
        case "Dec":
        case "dec":
        case "Prosinac":
        case "pro":
            $mesec = "12";
            break;
    }

    return $mesec;
}



function fetchUrl($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    // You may need to add the line below
    // curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);

    $retData = curl_exec($ch);
    curl_close($ch);

    return $retData;
}

function utf8_fix($string) {
    $string = str_replace('Å¡', 'š', $string);
    $string = str_replace('Å¾', 'ž', $string);
    $string = str_replace('Ä', 'č', $string);

    return $string;
}

function utf8_fix2($string) {
    $string = str_replace('Â', 'š', $string);
    $string = str_replace('Â', 'ž', $string);
    $string = str_replace('Ã¨', 'č', $string);
    $string = str_replace('Ã¦', 'ć', $string);

    return $string;
}

function skrajsaj($str, $length) {

    $arr = explode('__BREAK__', wordwrap($str, $length, "__BREAK__", true));
    return $arr[0];
}

if (!function_exists('dump')) {

    function dump($var, $label = 'Dump', $echo = TRUE) {
// Store dump in variable
        ob_start();
        var_dump($var);
        $output = ob_get_clean();
// Add formatting
        $output = preg_replace("/\]\=\>\n(\s+)/m", "] => ", $output);
        $output = '<pre style="background: #FFFEEF; color: #000; border: 1px dotted #000; padding: 10px; margin: 10px 0; text-align: left;">' . $label . ' => ' . $output . '</pre>';
// Output
        if ($echo == TRUE) {
            echo $output;
        } else {
            return $output;
        }
    }

}

function array_orderby() {
    $args = func_get_args();
    $data = array_shift($args);
    foreach ($args as $n => $field) {
        if (is_string($field)) {
            $tmp = array();
            foreach ($data as $key => $row)
                $tmp[$key] = $row[$field];
            $args[$n] = $tmp;
        }
    }
    $args[] = &$data;
    call_user_func_array('array_multisort', $args);
    return array_pop($args);
}

function btn_view($uri, $tooltip = NULL) {
    return anchor($uri, '<button type="button" class="btn btn-primary" data-toggle="tooltip" data-placement="bottom" title="' . $tooltip . '"><span class="glyphicon glyphicon-user"></span></button>');
}

function btn_items($uri, $tooltip = NULL) {
    return anchor($uri, '<button type="button" class="btn btn-info" data-toggle="tooltip" data-placement="bottom" title="' . $tooltip . '"><span class="glyphicon glyphicon-list"></span></button>');
}

function btn_duplicate($uri, $tooltip = NULL) {
    return anchor($uri, '<button type="button" class="btn btn-info" data-toggle="tooltip" data-placement="bottom" title="' . $tooltip . '"><span class="glyphicon glyphicon-tag"></span></button>');
}

function btn_edit($uri, $tooltip = NULL) {
    return anchor($uri, '<button type="button" class="btn btn-warning" data-toggle="tooltip" data-placement="bottom" title="' . $tooltip . '"><span class="glyphicon glyphicon-edit"></span></button>');
}

function btn_delete($uri, $tooltip = NULL) {
    return anchor($uri, '<button type="button" class="btn btn-danger" data-toggle="tooltip" data-placement="bottom" title="' . $tooltip . '"><span class="glyphicon glyphicon-remove"></span></button>', array(
        'onclick' => "return confirm('Are you sure?');"
    ));
}

function resize0($filename) {
    if ($filename != "") {
        $parts = explode("/", $filename);

        $filename2 = end($parts);
        $folder = 'hub' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        $directory = DIR_IMAGE2 . $folder;

        if (!is_dir($directory)) {
            $oldmask = umask(0);
            mkdir($directory, 0777, true);
            umask($oldmask);
        }

        $new_image = url_frendly2($filename2);
        $filename = str_replace(' ', '%20', preg_replace('/([^:])(\/{2,})/', '$1/', $filename));

        if (!file_exists("http://static.sconnected.net/img/temp/" . $new_image)) {

            $content = curl_domzale($filename);
            //Store in the filesystem.
            $fp = fopen(DIR_IMAGE2 . "temp/" . $new_image, "w+");
            fwrite($fp, $content);
            fclose($fp);
        }
        if (!file_exists(DIR_IMAGE2 . $folder . $new_image)) {
            $image = new Image_moo;
            $image->load(DIR_IMAGE2 . "temp/" . $new_image)
                    ->resize(300, 600)
                    ->save(DIR_IMAGE2 . $folder . $new_image);
        }

        return 'http://static.sconnected.net/img/' . $folder . $new_image;
    }
}

function resize0_hires($filename) {
    if ($filename != "") {
        $parts = explode("/", $filename);
        $filename2 = end($parts);

        $folder = 'hub' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        $directory = DIR_IMAGE2 . 'hires/' . $folder;
        if (!is_dir($directory)) {
            $oldmask = umask(0);
            mkdir($directory, 0777, true);
            umask($oldmask);
        }

        $new_image = url_frendly2($filename2);
        $filename = str_replace(' ', '%20', preg_replace('/([^:])(\/{2,})/', '$1/', $filename));

        if (!file_exists("http://static.sconnected.net/img/temp/" . $new_image)) {

            $content = curl_domzale($filename);
            //Store in the filesystem.
            $fp = fopen(DIR_IMAGE2 . "temp/" . $new_image, "w+");
            fwrite($fp, $content);
            fclose($fp);
        }
        if (!file_exists(DIR_IMAGE2 . 'hires/' . $folder . $new_image)) {
            $image = new Image_moo;
            $image->load(DIR_IMAGE2 . "temp/" . $new_image)
                    ->resize(600, 1200)
                    ->save(DIR_IMAGE2 . 'hires/' . $folder . $new_image);
        }

        return 'http://static.sconnected.net/img/hires/' . $folder . $new_image;
    }
}

function curl_domzale($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_USERAGENT, "Googlebot/2.1 (+http://www.google.com/bot.html)");

    $return = curl_exec($ch);
    curl_close($ch);
    return $return;
}
